using System;
using Server;
using Server.Items;

namespace Xanthos.Evo
{
	public sealed class EvoGolemSpec : BaseEvoSpec
	{
		// This class implements a singleton pattern; meaning that no matter how many times the
		// Instance attribute is used, there will only ever be one of these created in the entire system.
		// Copy this template and give it a new name.  Assign all of the data members of the EvoSpec
		// base class in the constructor.  Your subclass must not be abstract.
		// Never call new on this class, use the Instance attribute to get the instance instead.

		EvoGolemSpec()
		{
			m_Tamable = true;
			m_MinTamingToHatch = 0;
			m_PercentFemaleChance = 0.00;	// Made small to limit access to eggs.
			m_GuardianEggOrDeedChance = 0.00;
			m_AlwaysHappy = true;
			m_ProducesYoung = false;
			m_AbsoluteStatValues = true;
			m_MaxEvoResistance = 90;
			m_MaxTrainingStage = 3;
			m_CanAttackPlayers = false;

			m_Skills = new SkillName[7] { SkillName.Meditation, SkillName.MagicResist,
										  SkillName.Tactics, SkillName.Wrestling, SkillName.Anatomy, SkillName.AnimalLore, SkillName.Veterinary };
			m_MinSkillValues = new int[7] { 20, 20, 30, 30, 30, 30, 30 };
			m_MaxSkillValues = new int[7] { 100, 100, 100, 100, 100, 100, 100 };

			m_Stages = new BaseEvoStage[] { 
            new EvoGolemStageOne(), new EvoGolemStageTwo(), new EvoGolemStageThree(), new EvoGolemStageFour(),
				new EvoGolemStageFive(), new EvoGolemStageSix(), new EvoGolemStageSeven(), new EvoGolemStageEight(),
            new EvoGolemStageNine(), new EvoGolemStageTen(), new EvoGolemStageEleven(), new EvoGolemStageTwelve(),
            new EvoGolemStageThirteen(), new EvoGolemStageForteen(), new EvoGolemStageFifteen(), new EvoGolemStageSixteen(),
            new EvoGolemStageSeventeen(), };
		}

		// These next 2 lines facilitate the singleton pattern.  In your subclass only change the
		// BaseEvoSpec class name to your subclass of BaseEvoSpec class name and uncomment both lines.
		public static EvoGolemSpec Instance { get { return Nested.instance; } }
		class Nested { static Nested() { } internal static readonly EvoGolemSpec instance = new EvoGolemSpec();}
	}	

	// Define a subclass of BaseEvoStage for each stage in your creature and place them in the
	// array in your subclass of BaseEvoSpec.  See the example classes for how to do this.
	// Your subclass must not be abstract.

	public class EvoGolemStageOne : BaseEvoStage
	{
		public EvoGolemStageOne()
		{
			Title = CraftResources.GetName( CraftResource.Iron );
         EvolutionMessage = "has evolved";
			NextEpThreshold = 30000; EpMinDivisor = 40; EpMaxDivisor = 40; DustMultiplier = 20;
			BodyValue = 752; ControlSlots = 3; VirtualArmor = 30;
			Hue = CraftResources.GetHue( CraftResource.Iron );

			DamagesTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinDamages = new int[1] { 100 };
			MaxDamages = new int[1] { 100 };

			ResistanceTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinResistances = new int[1] { 15 };
			MaxResistances = new int[1] { 15 };

			DamageMin = 13; DamageMax = 17; HitsMin = 200; HitsMax = 200;
			StrMin = 300; StrMax = 300; DexMin = 70; DexMax = 70; IntMin = 30; IntMax = 30;
		}
	}

	public class EvoGolemStageTwo : BaseEvoStage
	{
		public EvoGolemStageTwo()
		{
			Title = CraftResources.GetName( CraftResource.DullCopper );
         EvolutionMessage = "has evolved";
			NextEpThreshold = 70000; EpMinDivisor = 200; EpMaxDivisor = 100; DustMultiplier = 20;
			VirtualArmor = 50;
			Hue = CraftResources.GetHue( CraftResource.DullCopper );
			
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 20, 20, 20, 20, 20 };
			MaxResistances = new int[5] { 20, 20, 20, 20, 20 };

			DamageMin = 13; DamageMax = 17; HitsMin= 250; HitsMax = 250;
			StrMin = 350; StrMax = 350; DexMin = 80; DexMax = 80; IntMin = 40; IntMax = 40;
		}
	}

	public class EvoGolemStageThree : BaseEvoStage
	{
		public EvoGolemStageThree()
		{
			Title = CraftResources.GetName( CraftResource.ShadowIron );
         EvolutionMessage = "has evolved";
			NextEpThreshold = 100000; EpMinDivisor = 400; EpMaxDivisor = 120; DustMultiplier = 20;
			VirtualArmor = 60;
			Hue = CraftResources.GetHue( CraftResource.ShadowIron );

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 30, 30, 30, 30, 30 };
			MaxResistances = new int[5] { 30, 30, 30, 30, 30 };	

			DamageMin = 13; DamageMax = 18; HitsMin= 350; HitsMax = 350;
			StrMin = 400; StrMax = 400; DexMin = 90; DexMax = 90; IntMin = 50; IntMax = 50;
		}
	}

	public class EvoGolemStageFour : BaseEvoStage
	{
		public EvoGolemStageFour()
		{
			Title = CraftResources.GetName( CraftResource.Copper );
         EvolutionMessage = "has evolved";
			NextEpThreshold = 130000; EpMinDivisor = 600; EpMaxDivisor = 150; DustMultiplier = 20;
			VirtualArmor = 70;
			Hue = CraftResources.GetHue( CraftResource.Copper );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 40, 40, 40, 40, 40 };
			MaxResistances = new int[5] { 40, 40, 40, 40, 40 };	

			DamageMin = 13; DamageMax = 18; HitsMin= 400; HitsMax = 400;
			StrMin = 450; StrMax = 450; DexMin = 90; DexMax = 90; IntMin = 55; IntMax = 55;
		}
	}

	public class EvoGolemStageFive : BaseEvoStage
	{
		public EvoGolemStageFive()
		{
			Title = CraftResources.GetName( CraftResource.Bronze );
         EvolutionMessage = "has evolved";
			NextEpThreshold = 165000; EpMinDivisor = 1000; EpMaxDivisor = 190; DustMultiplier = 20;
			VirtualArmor = 90;
			Hue = CraftResources.GetHue( CraftResource.Bronze );

			DamageMin = 13; DamageMax = 18; HitsMin= 450; HitsMax = 450;
			StrMin = 475; StrMax = 475; DexMin = 100; DexMax = 100; IntMin = 55; IntMax = 55;
		}
	}

	public class EvoGolemStageSix : BaseEvoStage
	{
		public EvoGolemStageSix()
		{
			Title = CraftResources.GetName( CraftResource.Gold );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 190000; EpMinDivisor = 1550; EpMaxDivisor = 510; DustMultiplier = 20;
			VirtualArmor = 100;
			Hue = CraftResources.GetHue( CraftResource.Gold );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 50, 50, 50, 50, 50 };
			MaxResistances = new int[5] { 50, 50, 50, 50, 50 };	

			DamageMin = 13; DamageMax = 18; HitsMin= 500; HitsMax = 500;
			StrMin = 500; StrMax = 500; DexMin = 110; DexMax = 110; IntMin = 60; IntMax = 60;
		}
	}
	
	public class EvoGolemStageSeven : BaseEvoStage
	{
		public EvoGolemStageSeven()
		{
			Title = CraftResources.GetName( CraftResource.Agapite );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 240000; EpMinDivisor = 1500; EpMaxDivisor = 550; DustMultiplier = 20;
			VirtualArmor = 110;
			Hue = CraftResources.GetHue( CraftResource.Agapite );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 55, 55, 55, 55, 55 };
			MaxResistances = new int[5] { 55, 55, 55, 55, 55 };	

			DamageMin = 13; DamageMax = 18; HitsMin= 600; HitsMax = 600;
			StrMin = 600; StrMax = 600; DexMin = 120; DexMax = 120; IntMin = 70; IntMax = 70;
		}
	}
	
	public class EvoGolemStageEight : BaseEvoStage
	{
		public EvoGolemStageEight()
		{
			Title = CraftResources.GetName( CraftResource.Verite );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 350000; EpMinDivisor = 1500; EpMaxDivisor = 700; DustMultiplier = 20;
			VirtualArmor = 110;
			Hue = CraftResources.GetHue( CraftResource.Verite );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 60, 60, 60, 60, 60 };
			MaxResistances = new int[5] { 60, 60, 60, 60, 60 };	

			DamageMin = 13; DamageMax = 19; HitsMin= 700; HitsMax = 700;
			StrMin = 700; StrMax = 700; DexMin = 130; DexMax = 130; IntMin = 80; IntMax = 80;
		}
	}
	
	public class EvoGolemStageNine : BaseEvoStage
	{
		public EvoGolemStageNine()
		{
			Title = CraftResources.GetName( CraftResource.Valorite );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 500000; EpMinDivisor = 2000; EpMaxDivisor = 1200; DustMultiplier = 20;
			VirtualArmor = 110;
			Hue = CraftResources.GetHue( CraftResource.Valorite );
			
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													 ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 50, 0, 20, 0, 30 };
			MaxDamages = new int[5] { 50, 0, 20, 0, 30 };
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 65, 65, 65, 65, 65 };
			MaxResistances = new int[5] { 65, 65, 65, 65, 65 };	

			DamageMin = 14; DamageMax = 20; HitsMin= 800; HitsMax = 800;
			StrMin = 750; StrMax = 750; DexMin = 140; DexMax = 140; IntMin = 90; IntMax = 90;
		}
	}
	
	public class EvoGolemStageTen : BaseEvoStage
	{
		public EvoGolemStageTen()
		{
			Title = CraftResources.GetName( CraftResource.Silver );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 750000; EpMinDivisor = 2000; EpMaxDivisor = 1250; DustMultiplier = 20;
			VirtualArmor = 110; ControlSlots = 4;
			Hue = CraftResources.GetHue( CraftResource.Silver );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 70, 70, 70, 70, 70 };
			MaxResistances = new int[5] { 70, 70, 70, 70, 70 };	

			DamageMin = 15; DamageMax = 21; HitsMin= 1000; HitsMax = 1000;
			StrMin = 800; StrMax = 800; DexMin = 145; DexMax = 145; IntMin = 90; IntMax = 90;
		}
	}
	
	public class EvoGolemStageEleven : BaseEvoStage
	{
		public EvoGolemStageEleven()
		{
			Title = CraftResources.GetName( CraftResource.Platinum );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 1000000; EpMinDivisor = 2000; EpMaxDivisor = 1250; DustMultiplier = 20;
			VirtualArmor = 130;
			Hue = CraftResources.GetHue( CraftResource.Platinum );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 70, 70, 70, 75, 70 };
			MaxResistances = new int[5] { 70, 70, 70, 75, 70 };	

			DamageMin = 15; DamageMax = 22; HitsMin= 1100; HitsMax = 1100;
			StrMin = 850; StrMax = 850; DexMin = 150; DexMax = 150; IntMin = 90; IntMax = 90;
		}
	}
	
	public class EvoGolemStageTwelve : BaseEvoStage
	{
		public EvoGolemStageTwelve()
		{
			Title = CraftResources.GetName( CraftResource.Mythril );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 3000000; EpMinDivisor = 2000; EpMaxDivisor = 1250; DustMultiplier = 20;
			VirtualArmor = 150;
			Hue = CraftResources.GetHue( CraftResource.Mythril );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 70, 70, 70, 80, 70 };
			MaxResistances = new int[5] { 70, 70, 70, 80, 70 };	

			DamageMin = 16; DamageMax = 23; HitsMin= 1300; HitsMax = 1300;
			StrMin = 875; StrMax = 875; DexMin = 155; DexMax = 155; IntMin = 90; IntMax = 90;
		}
	}
	
	public class EvoGolemStageThirteen : BaseEvoStage
	{
		public EvoGolemStageThirteen()
		{
			Title = CraftResources.GetName( CraftResource.Obsidian );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 7000000; EpMinDivisor = 2000; EpMaxDivisor = 1250; DustMultiplier = 20;
			VirtualArmor = 180;
			Hue = CraftResources.GetHue( CraftResource.Obsidian );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 75, 75, 75, 80, 75 };
			MaxResistances = new int[5] { 75, 75, 75, 80, 75 };	

			DamageMin = 17; DamageMax = 25; HitsMin= 1500; HitsMax = 1500;
			StrMin = 900; StrMax = 900; DexMin = 160; DexMax = 160; IntMin = 90; IntMax = 90;
		}
	}
	
	public class EvoGolemStageForteen : BaseEvoStage
	{
		public EvoGolemStageForteen()
		{
			Title = CraftResources.GetName( CraftResource.Jade );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 12000000; EpMinDivisor = 2000; EpMaxDivisor = 1250; DustMultiplier = 20;
			VirtualArmor = 190;
			Hue = CraftResources.GetHue( CraftResource.Jade );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 80, 80, 80, 85, 80 };
			MaxResistances = new int[5] { 80, 80, 80, 85, 80 };	

			DamageMin = 18; DamageMax = 26; HitsMin= 1700; HitsMax = 1700;
			StrMin = 925; StrMax = 925; DexMin = 165; DexMax = 165; IntMin = 90; IntMax = 90;
		}
	}
	
	public class EvoGolemStageFifteen : BaseEvoStage
	{
		public EvoGolemStageFifteen()
		{
			Title = CraftResources.GetName( CraftResource.Moonstone );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 18000000; EpMinDivisor = 2000; EpMaxDivisor = 1300; DustMultiplier = 20;
			VirtualArmor = 200;
			Hue = CraftResources.GetHue( CraftResource.Moonstone );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 85, 80, 80, 90, 80 };
			MaxResistances = new int[5] { 85, 80, 80, 90, 80 };	

			DamageMin = 20; DamageMax = 26; HitsMin= 2000; HitsMax = 2000;
			StrMin = 950; StrMax = 950; DexMin = 170; DexMax = 170; IntMin = 100; IntMax = 100;
		}
	}
	
	public class EvoGolemStageSixteen : BaseEvoStage
	{
		public EvoGolemStageSixteen()
		{
			Title = CraftResources.GetName( CraftResource.Sunstone );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 25000000; EpMinDivisor = 2000; EpMaxDivisor = 1300; DustMultiplier = 20;
			VirtualArmor = 220;
			Hue = CraftResources.GetHue( CraftResource.Sunstone );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 90, 85, 85, 95, 85 };
			MaxResistances = new int[5] { 90, 85, 85, 95, 85 };	

			DamageMin = 22; DamageMax = 28; HitsMin= 2250; HitsMax = 2250;
			StrMin = 975; StrMax = 975; DexMin = 175; DexMax = 175; IntMin = 100; IntMax = 100;
		}
	}
	
	public class EvoGolemStageSeventeen : BaseEvoStage
	{
		public EvoGolemStageSeventeen()
		{
			Title = CraftResources.GetName( CraftResource.Bloodstone );
			EvolutionMessage = "has evolved";
			NextEpThreshold = 0; EpMinDivisor = 2000; EpMaxDivisor = 1500; DustMultiplier = 20;
			VirtualArmor = 250;
			Hue = CraftResources.GetHue( CraftResource.Bloodstone );
		
			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 90, 90, 90, 95, 90 };
			MaxResistances = new int[5] { 90, 90, 90, 95, 90 };	

			DamageMin = 23; DamageMax = 30; HitsMin= 2500; HitsMax = 2500;
			StrMin = 980; StrMax = 980; DexMin = 180; DexMax = 180; IntMin = 100; IntMax = 100;
		}
	}
}